Attribute VB_Name = "modRichText"
'-----------------------------------------------------
' MirageBot RichTextBox Manipulation Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Const WM_PASTE As Long = &H302
Private Type NMHDR
    hWndFrom As Long
    idFrom As Long
    Code As Long
End Type

Private Type CHARRANGE
    cpMin As Long
    cpMax As Long
End Type

Private Type ENLINK
    hdr As NMHDR
    msg As Long
    wParam As Long
    lParam As Long
    chrg As CHARRANGE
End Type

Private Type TEXTRANGE
    chrg As CHARRANGE
    lpstrText As String
End Type

Const EM_GETSCROLLPOS As Long = &H400 + 221
Const EM_SETSCROLLPOS As Long = &H400 + 222
Const EM_CHARFROMPOS As Long = &HD7
Const EM_SETEVENTMASK As Long = &H445
Const EM_GETEVENTMASK As Long = &H43B
Const EM_GETTEXTRANGE As Long = &H44B
Const EM_AUTOURLDETECT As Long = &H45B
Const EN_LINK As Long = &H70B
Const ENM_LINK As Long = &H4000000

Const WM_NOTIFY As Long = &H4E
Const WM_LBUTTONDBLCLK As Long = &H203
Const WM_LBUTTONDOWN As Long = &H201
Const WM_LBUTTONUP As Long = &H202
Const WM_MOUSEMOVE As Long = &H200
Const WM_RBUTTONDBLCLK As Long = &H206
Const WM_RBUTTONDOWN As Long = &H204
Const WM_RBUTTONUP As Long = &H205
Const WM_SETCURSOR As Long = &H20

Const CFE_LINK As Long = &H20
Const GWL_WNDPROC As Long = (-4)
Const GWL_EXSTYLE As Long = (-20)
Const SW_SHOW As Long = 5
Const WS_EX_TRANSPARENT As Long = &H20&

Dim lOldProc As Long 'Old windowproc
Dim hWndRTB As Long 'hWnd of RTB
Dim hWndParent As Long 'hWnd of parent window
Private Declare Function WriteFile Lib "kernel32.dll" (ByVal iFileHandle As Long, lpBuffer As Any, ByVal nNumberOfBytesToWrite As Long, lpNumberOfBytesWritten As Long, ByVal lpOverlapped As Long) As Long
Private Declare Function CreateFileA Lib "kernel32" _
  (ByVal lpFileName As String, _
   ByVal dwDesiredAccess As Long, _
   ByVal dwShareMode As Long, _
   ByVal lpSecurityAttributes As Long, _
   ByVal dwCreationDisposition As Long, _
   ByVal dwFlagsAndAttributes As Long, _
   ByVal hTemplateFile As Long) As Long
Private Declare Function SetFilePointer Lib "kernel32" (ByVal hFile As Long, ByVal lDistanceToMove As Long, lpDistanceToMoveHigh As Long, ByVal dwMoveMethod As Long) As Long
Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Private Const OPEN_ALWAYS As Long = 4
Private Const FILE_BEGIN As Long = 0
Private Const FILE_END As Long = 2
Private Const GENERIC_WRITE As Long = &H40000000
Private Const GENERIC_READ As Long = &H80000000
Private Const FILE_ATTRIBUTE_NORMAL As Long = &H80

Public Function API_AppendFile(sFile As String, sText As String)
    Dim hFile As Long, lpFileSize As Currency, bText() As Byte, iLength As Long
    hFile = CreateFileA(sFile, _
                GENERIC_WRITE Or GENERIC_READ, 0&, ByVal 0&, _
                OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0&)
    bText = StringToBytes(sText)
    SetFilePointer hFile, 0, 0, FILE_END
    WriteFile hFile, bText(0), UBound(bText) + 1, 0, 0&
    CloseHandle hFile
End Function

Private Function StringToBytes(S As String) As Byte()
    Dim B() As Byte, I As Integer
    ReDim B(Len(S) - 1)
    For I = 1 To Len(S)
        B(I - 1) = Asc(Mid$(S, I, 1))
    Next I
    StringToBytes = B
End Function




'private static extern int SendMessage(IntPtr hwndLock,Int32 wMsg,Int32 wParam, ref Point pt);
'
'
'// *** Get / Change Scroll Position ***
'private Point RTBScrollPos
'{
'get
'{
'const int EM_GETSCROLLPOS = 0x0400 + 221;
'Point pt = new Point();
'
'SendMessage(this.rtbMain.Handle, EM_GETSCROLLPOS, 0, ref pt);
'return pt;
'}
'set
'{
'const int EM_SETSCROLLPOS = 0x0400 + 222;
'
'SendMessage(this.rtbMain.Handle, EM_SETSCROLLPOS, 0, ref value);
'}
'}

' Return the word the mouse is over.
'Public Function RichWordOver(rch As RichTextBox, x As _
'    Single, y As Single) As String
'    Dim pt As POINTAPI
'    Dim pos As Integer
'    Dim start_pos As Integer
'    Dim end_pos As Integer
'    Dim ch As String
'    Dim txt As String
'    Dim txtlen As Integer
'
'    ' Convert the position to pixels.
'    pt.x = x \ Screen.TwipsPerPixelX
'    pt.y = y \ Screen.TwipsPerPixelY
'
'    ' Get the character number
'    pos = SendMessage(rch.hwnd, EM_CHARFROMPOS, 0&, pt)
'    If pos <= 0 Then Exit Function
'
'    ' Find the start of the word.
'    txt = rch.Text
'    For start_pos = pos To 1 Step -1
'        ch = Mid$(rch.Text, start_pos, 1)
'        ' Allow digits, letters, and underscores.
'        If Not ( _
'            (ch >= "0" And ch <= "9") Or _
'            (ch >= "a" And ch <= "z") Or _
'            (ch >= "A" And ch <= "Z") Or _
'            ch = "_" _
'        ) Then Exit For
'    Next start_pos
'    start_pos = start_pos + 1
'
'    ' Find the end of the word.
'    txtlen = Len(txt)
'    For end_pos = pos To txtlen
'        ch = Mid$(txt, end_pos, 1)
'        ' Allow digits, letters, and underscores.
'        If Not ( _
'            (ch >= "0" And ch <= "9") Or _
'            (ch >= "a" And ch <= "z") Or _
'            (ch >= "A" And ch <= "Z") Or _
'            ch = "_" _
'        ) Then Exit For
'    Next end_pos
'    end_pos = end_pos - 1
'
'    If start_pos <= end_pos Then _
'        RichWordOver = Mid$(txt, start_pos, end_pos - _
'            start_pos + 1)
'End Function
'
''Public Function GetScrollPosition(ByVal hWndTextbox As Long) As POINTAPI
'    Dim pt As POINTAPI
'    Call SendMessage(hWndTextbox, EM_GETSCROLLPOS, 0, pt)
'    GetScrollPosition = pt
'End Function

Public Sub LogText(Index As Integer, Text As String)
On Error GoTo hErr
    If LenB(frmBot.Bot(Index).Profile) = 0 Then Exit Sub
    Dim Path As String, FF As Integer
    FF = FreeFile
    Path = AppData & "Profiles\" & frmBot.Bot(Index).Profile
    CreateFolder Path
    Path = Path & "\Logs"
    CreateFolder Path
    Path = Path & "\" & MonthName(Month(Date)) & Space$(1) & Year(Date)
    CreateFolder Path
    Path = Path & "\" & Format$(Day(Date), "00") & " " & WeekdayName(Weekday(Date), False) & ".log"
    If CreateFile(Path) = True Then
        API_AppendFile Path, frmBot.Bot(Index).Profile & " log file for " & Date & vbNewLine & Replace$(Text, vbNewLine, vbNullString)
'        Open Path For Append As #FF
'            Print #FF, frmBot.Bot(Index).Profile & " log file for " & Date
'        Close #FF
    Else
        API_AppendFile Path, Replace$(Text, vbNewLine, vbNullString)
    End If
'    Open Path For Append As #FF
'        Print #FF, Replace$(Text, vbNewLine, vbNullString)
'    Close #FF
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "ReadWrite", "LogText"
End Sub

Public Sub LogHTML(Index As Integer, Text As String)
On Error GoTo hErr
    If LenB(frmBot.Bot(Index).Profile) = 0 Then Exit Sub
    Dim Path As String
    Path = AppData & "Profiles\" & frmBot.Bot(Index).Profile
    CreateFolder Path
    Path = Path & "\Logs"
    CreateFolder Path
    Path = Path & "\" & MonthName(Month(Date)) & Space$(1) & Year(Date)
    CreateFolder Path
    Path = Path & "\" & Format$(Day(Date), "00") & " " & WeekdayName(Weekday(Date), False) & ".html"
    If CreateFile(Path) = True Then
        API_AppendFile Path, "<title>MirageBot [" & frmBot.Bot(Index).Profile & "] log for " & Date & "</title>" & _
                "<style type=text/css>font { font-family: Verdana, Arial, sans-serif; font-size: 14px; }</style></head>" & _
                "<body bgcolor=#000000><font color=#FFFFFF><h3>" & _
                frmBot.Bot(Index).Profile & " log file for " & Date & "</h3></font>" & Replace$(Text, vbNewLine, "<br/>")
'        Open Path For Append As #8
'            Print #8, "<title>MirageBot [" & frmBot.Bot(Index).Profile & "] log for " & Date & "</title>" & _
'                "<style type=text/css>font { font-family: Verdana, Arial, sans-serif; font-size: 14px; }</style></head>" & _
'                "<body bgcolor=#000000><font color=#FFFFFF><h3>" & _
'                frmBot.Bot(Index).Profile & " log file for " & Date & "</h3></font>"
'            Print #8, Replace$(Text, vbNewLine, "<br/>")
'        Close #8
    Else
        API_AppendFile Path, Replace$(Text, vbNewLine, "<br/>")
'        Open Path For Append As #9
'            Print #9, Replace$(Text, vbNewLine, "<br/>")
'        Close #9
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "ReadWrite", "LogHTML"
End Sub

Public Function HTMLFormat(ByVal lngColor As Long, ByVal strLine As String) As String
    If strLine = vbNewLine Then
        HTMLFormat = strLine
        Exit Function
    End If
    
    Dim strColorCode As String
    strColorCode = Right$("000000" & Hex$(lngColor), 6)
    strColorCode = Right$(strColorCode, 2) & Mid$(strColorCode, 3, 2) & Left$(strColorCode, 2)
    
    strLine = Replace(strLine, "&", "&amp;")
    strLine = Replace(strLine, "<", "&lt;")
    strLine = Replace(strLine, ">", "&gt;")
    
    HTMLFormat = "<font color=#" & strColorCode & ">" & strLine & "</font>"
End Function

Public Sub EnableURLDetect(ByVal hWndTextbox As Long, ByVal hWndOwner As Long)
    'Don't want to subclass twice!
    If lOldProc = 0 Then
    'Subclass!
    lOldProc = SetWindowLong(hWndOwner, GWL_WNDPROC, AddressOf WndProc)
    
    'Tell the RTB to inform us when stuff happens to URLs
    SendMessage hWndTextbox, EM_SETEVENTMASK, 0, ByVal ENM_LINK Or SendMessage(hWndTextbox, EM_GETEVENTMASK, 0, 0)
    'Tell the RTB to start automatically detecting URLs
    'SendMessage hWndTextbox, EM_AUTOURLDETECT, 1, ByVal 0
    
    hWndParent = hWndOwner
    hWndRTB = hWndTextbox
    End If
End Sub

Public Sub URLViewing(B As Boolean, ByVal hWndRTB As Long)
    If B Then
        SendMessage hWndRTB, EM_AUTOURLDETECT, 1, ByVal 0
    Else
        SendMessage hWndRTB, EM_AUTOURLDETECT, 0, ByVal 0
    End If
End Sub

Public Sub DisableURLDetect()
    'Don't want to unsubclass a non-subclassed window
    If lOldProc Then
    'Stop URL detection
    'SendMessage hWndRTB, EM_AUTOURLDETECT, 1, ByVal 0
    'Reset the window procedure (stop the subclassing)
    SetWindowLong hWndParent, GWL_WNDPROC, lOldProc
    'Set this to 0 so we can subclass again in future
    lOldProc = 0
    End If
End Sub

Private Sub RTBRefresh(R As RichTextBox)
    If R.Visible Then
        R.Visible = Not R.Visible
        R.Visible = Not R.Visible
        R.Refresh
    End If
End Sub

Public Sub TransparentRTB()
    Dim R As RichTextBox
    For Each R In frmBot.rtbChat
        SetWindowLong R.hwnd, GWL_EXSTYLE, WS_EX_TRANSPARENT
        RTBRefresh R
    Next R
    For Each R In frmBot.rtbWhsp
        SetWindowLong R.hwnd, GWL_EXSTYLE, WS_EX_TRANSPARENT
        RTBRefresh R
    Next R
End Sub

Public Sub OpaqueRTB()
    Dim R As RichTextBox
    For Each R In frmBot.rtbChat
        SetWindowLong R.hwnd, GWL_EXSTYLE, 0
        RTBRefresh R
    Next R
    For Each R In frmBot.rtbWhsp
        SetWindowLong R.hwnd, GWL_EXSTYLE, 0
        RTBRefresh R
    Next R
End Sub

Public Function WndProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim uHead As NMHDR
    Dim eLink As ENLINK
    Dim eText As TEXTRANGE
    Dim sText As String
    Dim lLen As Long
    
    'Which message?
    Select Case uMsg
    Case WM_NOTIFY
    
    'Ooo! A notify message! Something exciting must be happening...
    'Copy the notification header into our structure from the pointer
    CopyMemory uHead, ByVal lParam, Len(uHead)
    
    'Peek inside the structure
    If (uHead.hWndFrom = hWndRTB) And (uHead.Code = EN_LINK) Then
    
    'Yay! Some kind of kinky linky message.
    'Now that we know its a link message, we can copy the whole ENLINK structure
    'into our structure
    CopyMemory eLink, ByVal lParam, Len(eLink)
    
    'What kind of message?
    Select Case eLink.msg
    Case WM_LBUTTONDBLCLK
    'Double clicked the link!
    
    'Set up out TEXTRANGE struct
    eText.chrg.cpMin = eLink.chrg.cpMin
    eText.chrg.cpMax = eLink.chrg.cpMax
    eText.lpstrText = Space$(1024)
    
    'Tell the RTB to fill out our TEXTRANGE with the text
    lLen = SendMessage(hWndRTB, EM_GETTEXTRANGE, 0, eText)
    
    'Trim the text
    sText = Left$(eText.lpstrText, lLen)
    
    'Launch the browser
    ShellExecute hWndParent, vbNullString, sText, vbNullString, vbNullString, SW_SHOW
    
    'Other miscellaneous messages
    Case WM_LBUTTONDOWN
    
    Case WM_LBUTTONUP
    
    Case WM_RBUTTONDBLCLK
    
    Case WM_RBUTTONDOWN
    
    Case WM_RBUTTONUP
    
    Case WM_SETCURSOR
    
    End Select
    
    End If
    
    End Select
    
    'Call the stored window procedure to let it handle all the messages
    WndProc = CallWindowProc(lOldProc, hwnd, uMsg, wParam, lParam)
End Function

Public Sub ReplaceColours(rtb As RichTextBox, dblStart As Double)
On Error GoTo hErr
    Dim Pos As Double, colour As Long
    Do
        Pos = rtb.Find("", dblStart)
        If (Pos > 0) Then
            rtb.SelStart = Pos
            rtb.SelLength = 2
            If Len(rtb.SelText) = 2 Then
                Select Case Mid$(rtb.SelText, 2)
                    Case "P", "W": colour = SCWhite
                    Case "Q": colour = SCGray
                    Case "R": colour = SCGreen
                    Case "S", "X", "Z": colour = SCYellow
                    Case "T", "U", "V": colour = SCCyan
                    Case "Y", "[": colour = SCRed
                    Case Else: colour = SCWhite
                End Select
            End If
            rtb.SelText = vbNullString
            rtb.SelStart = Pos
            rtb.SelLength = 200000000
            rtb.SelColor = colour
        End If
    Loop Until (Pos < 1) Or (Err)
    Do
        Pos = rtb.Find("c", dblStart)
        If (Pos > 0) Then
            Dim Bold As Boolean, Italic As Boolean, Underline As Boolean, Strike As Boolean
            Strike = False
            Bold = False
            Italic = False
            Underline = False
            rtb.SelStart = Pos
            rtb.SelLength = 3
            If Len(rtb.SelText) = 3 Then
                Select Case Mid$(rtb.SelText, 3)
                    Case "0": colour = D2White
                    Case "1": colour = D2Red
                    Case "2": colour = D2Green
                    Case "3": colour = D2Blue
                    Case "4": colour = D2Beige
                    Case "5": colour = D2Gray
                    Case "6": colour = D2Black
                    Case "7": colour = D2Beige2
                    Case "8": colour = D2Orange
                    Case "9": colour = D2LtYellow
                    Case ":": colour = D2MdGreen
                    Case ";": colour = D2Purple
                    Case "<": colour = D2DkGreen
                    Case "B": Bold = True
                    Case "I": Italic = True
                    Case "S": Strike = True
                    Case "U": Underline = True
                    Case Else: colour = D2White
                End Select
            End If
            rtb.SelText = vbNullString
            rtb.SelStart = Pos
            rtb.SelLength = 200000000
            If Bold Then rtb.SelBold = Not rtb.SelBold
            If Italic Then rtb.SelItalic = Not rtb.SelItalic
            If Underline Then rtb.SelUnderline = Not rtb.SelUnderline
            If Strike Then rtb.SelStrikeThru = Not rtb.SelStrikeThru
            If colour <> &H0 Then rtb.SelColor = colour
        End If
    Loop Until (Pos < 1) Or (Err)
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "RichTextBox", "ReplaceColours"
End Sub

Public Function FormatSmilies(ByVal Message As String) As String
    If Options.Smileys = False Then FormatSmilies = Message: Exit Function
    With frmBot.imlSmiley.ListImages
        Dim I As Integer
        For I = 1 To .Count
            Dim S() As String, X As Integer
            S = Split(.Item(I).Tag, "#")
            For X = 0 To UBound(S)
                If InStrB(Message, S(X)) <> 0 Then Message = Replace$(Message, S(X), "" & S(X) & "")
            Next X
        Next I
    End With
    FormatSmilies = Message
End Function

Public Sub ImportEmoticons()
    Dim Emoticons() As String, I As Integer
    Emoticons = FileList(AppData & "Emoticons\*.ini")
    For I = frmBot.mnuEmoIcon.UBound To 1 Step -1
        Unload frmBot.mnuEmoIcon(I)
    Next I
    frmBot.mnuEmoIcon(0).Caption = vbNullString
    For I = 0 To UBound(Emoticons)
        If Len(Emoticons(I)) > 4 Then
            If LenB(frmBot.mnuEmoIcon(0).Caption) = 0 Then
                frmBot.mnuEmoIcon(0).Caption = Left$(Emoticons(I), Len(Emoticons(I)) - 4)
            Else
                Load frmBot.mnuEmoIcon(frmBot.mnuEmoIcon.Count)
                frmBot.mnuEmoIcon(frmBot.mnuEmoIcon.UBound).Caption = Left$(Emoticons(I), Len(Emoticons(I)) - 4)
            End If
            frmBot.mnuEmoIcon(frmBot.mnuEmoIcon.UBound).Checked = (LCase$(frmBot.mnuEmoIcon(frmBot.mnuEmoIcon.UBound).Caption) = LCase$(Options.SmileySet))
        End If
    Next I
End Sub

Public Sub ReplaceEmoticons(rtb As RichTextBox, StartPos As Double)
    rtb.Locked = False
    With frmBot.imlSmiley.ListImages
        Dim I As Integer
        For I = 1 To .Count
            Dim S() As String, X As Integer
            S = Split(.Item(I).Tag, "#")
            For X = 0 To UBound(S)
                ReplaceEmoticon rtb, StartPos, "" & S(X) & "", I
            Next X
        Next
    End With
    rtb.Locked = True
End Sub

Private Sub ReplaceEmoticon(rtb As RichTextBox, dblStart As Double, strCompare As String, intPicture As Integer)
On Error GoTo hErr
    Dim Pos As Double
    Do
        Pos = rtb.Find(strCompare, dblStart)
        If (Pos > 0) Then
            rtb.SelStart = Pos
            rtb.SelLength = Len(strCompare)
            rtb.SelText = vbNullString
            InsertPicture rtb, frmBot.imlSmiley.ListImages(intPicture).Picture
        End If
    Loop Until (Pos < 1) Or (Err)
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "RichTextBox", "ReplaceEmoticon"
End Sub

Public Sub InsertPicture(rtb As RichTextBox, pic As StdPicture)
    On Error Resume Next
    Clipboard.Clear
    Clipboard.SetData pic
    SendMessage rtb.hwnd, WM_PASTE, 0&, 0&
End Sub

